      # Calculate 3D geometrical parameters of the coil strands, including copper length and resistance


            def geometry_3d(self):
                
                l_fe = self.l_fe                   #Active part length
                l_str_ew = self.l_str_ew           #Straight outside active part length before bending
                l_terminal = self.l_terminal       #winding terminal length(straight part outside active region+ending)
                
                #Insulation data matrix
                insulation_data = self.coil_insulation_system   #(insulation_data = get_insulation_data())  ???(tamrin)
                
                #--------------------MATERIAL DATA----------------------#
                #Material properties
                
                #Data_Cu=Get_Material_Data('Copper.txt')
                # Copper conductivity at 20°C
                #self.sigma20_Cu=Data_Cu.get_sigma()
                self.sigma20_Cu=mat_Copper_gamma20
                # Temperature coefficient at 20°C
                #self.alpha_Cu=Data_Cu.get_alpha()
                self.alpha_Cu=mat_Copper_alpha
                # Relative permeability
                #self.mur_Cu=Data_Cu.get_mur()
                self.mur_Cu=mat_Copper_mur
                
                mat_Copper_gamma20=self.mat_Copper_gamma20
                mat_Copper_alpha=self.mat_Copper_alpha
                mat_Copper_mur=self.mat_Copper_mur
                mat_Copper_gamma=self.mat_Copper_gamma
                
                
                #geometry calc. from previous 2D function
                geom2d = self.gemetry_2d()
                
                #Number of strands
                num_strands = len(geom2d['copper_widths']     #????
                n_parallels_v = self.n_parallels_v 
                n_parallels_h = self.n_parallels_h
                
                
                #Initialiye list for strand resistance
                resistances = []
                
                #calculate copper length and resistance
                
                for i in range(num_strands):
                    copper_length = 2 * (l_fe + l_str_ew) + l_terminal          #simplistic approximation
                    
                # Resistance calculation,   Resistance = resistivity * length / cross-sectional area
                cross_sectional_area = geom2d['copper_area_per_strand'][i]
                resistance = resistivity_Copper * copper_length / cross_sectional_area

                resistances.append(resistance)
                                              
                 # Total coil resistance
                total_resistance = sum(resistances)
                
                
                # Initialize arrays for each strand
                copper_lengths = np.zeros(n_horizontal)       # in mm
                resistances = np.zeros(n_horizontal)          # in Ohms
                
                # Calculate length for each strand
               
                
                # Store results
                self.geometry_results_3d = {
                    'copper_lengths': [2 * (l_fe + l_str_ew) + l_terminal for _ in range(num_strands)],
                    'resistances_per_strand': resistances,
                    'total_resistance': total_resistance
                }

                return self.geometry_results_3d
                